// EditCH.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "EditCH.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditCH dialog


CEditCH::CEditCH(CWnd* pParent /*=NULL*/)
	: CDialog(CEditCH::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditCH)
	m_Age = _T("");
	m_Country = _T("");
	m_DOB = _T("");
	m_FirstName = _T("");
	m_LastName = _T("");
	m_Phno = _T("");
	m_Street = _T("");
	m_State = _T("");
	//}}AFX_DATA_INIT
}

CEditCH ::CEditCH(IApplication *pApp):CDialog(CEditCH::IDD, NULL)
{
	pApplication = pApp;
	varPhoto.vt = VT_NULL;
	varSignature.vt = VT_NULL;
	vgetphoto.Clear();
	vgetSignature.Clear();
	pCardHolder.CreateInstance(__uuidof(CardHolder));
	
}

void CEditCH::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditCH)
	DDX_Control(pDX, ID_SAVE_SIG, m_Btn_SigSave);
	DDX_Control(pDX, ID_SAVE, m_Btn_PhotoSave);
	DDX_Control(pDX, IDC_AGE, m_cnt_age);
	DDX_Control(pDX, IDC_COUNTRY, m_cnt_country);
	DDX_Control(pDX, IDC_STATE, m_cnt_State);
	DDX_Control(pDX, IDC_ST, m_Cnt_St);
	DDX_Control(pDX, IDC_PHNO, m_Cnt_PHno);
	DDX_Control(pDX, IDC_DOB, m_Cnt_DOB);
	DDX_Control(pDX, IDC_LNAME, m_Cnt_LName);
	DDX_Control(pDX, IDC_FNAME, m_cnt_FName);
	DDX_Control(pDX, IDC_CHLIST, m_ChList);
	DDX_Control(pDX, IDC_NFTDETAILS, m_Nfts);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Text(pDX, IDC_AGE, m_Age);
	DDX_Text(pDX, IDC_COUNTRY, m_Country);
	DDX_Text(pDX, IDC_DOB, m_DOB);
	DDX_Text(pDX, IDC_FNAME, m_FirstName);
	DDX_Text(pDX, IDC_LNAME, m_LastName);	
	DDX_Text(pDX, IDC_PHNO, m_Phno);
	DDX_Text(pDX, IDC_ST, m_Street);
	DDX_Text(pDX, IDC_STATE, m_State);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditCH, CDialog)
	//{{AFX_MSG_MAP(CEditCH)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_CBN_SELCHANGE(IDC_CHLIST, OnSelchangeChlist)
	ON_BN_CLICKED(IDEDIT, OnEdit)
	ON_BN_CLICKED(ID_PHOTO, OnPhoto)
	ON_BN_CLICKED(ID_SIG, OnSig)
	ON_BN_CLICKED(ID_SAVE, OnSave)
	ON_BN_CLICKED(ID_SAVE_SIG, OnSaveSig)
	ON_BN_CLICKED(ID_DELPHOTO, OnDelphoto)
	ON_BN_CLICKED(ID_DELSIG, OnDelsig)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditCH message handlers
BOOL CEditCH::OnInitDialog() 
{
	CDialog::OnInitDialog();
	LoadAccounts(); // load account details in WP-CS system
	m_Btn_PhotoSave.EnableWindow(FALSE);
	m_Btn_SigSave.EnableWindow(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
void CEditCH :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				m_AcctList.SetItemData(m_AcctList.AddString(pAccount->AccountName),pAccount->AccountID);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}

void CEditCH :: LoadSubAccounts()
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
				
		//select AccountID
		int index_Acct = m_AcctList.GetCurSel();
		long lAccountID = m_AcctList.GetItemData(index_Acct);	

		if(lAccountID <= 0)
		{
			AfxMessageBox(L"Select Account!");
			return;
		}
		pApplication->GetSubAccountsByAccountID(lAccountID, &vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pSubAccount= NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount!= NULL)
			{				
				m_SubAcctList.SetItemData(m_SubAcctList.AddString(pSubAccount->AccountName), pSubAccount->AccountID);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	
	//m_AccountList.SetCurSel(0);
	
}


void CEditCH :: GetNFtemplateDetails()
{
		BSTR bstrAcctName;	
		BSTR bstrSubAcctName;	
		//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		CString sNFname, sNFMask, sCon;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}

		//select Sub account name 
		int index_SubAccount = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		if (index_SubAccount <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}

		_variant_t vnfts;
		vnfts.Clear();
		//get note field tempalte detaisl os specified account
		pApplication->GetNoteFieldTemplateDetailsByAccount(bstrAcctName, bstrSubAcctName, &vnfts);

		if(vnfts.vt == VT_EMPTY || vnfts.parray->rgsabound->cElements == 0)
		{
			AfxMessageBox(L"No Notefield templates in selected account");
			return;
		}
				
		long uBound =0 ;
		INoteField *pNFT = NULL;
		
		COleSafeArray sa(vnfts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_INoteField,(void**)&pNFT);
			if (pNFT != NULL)
			{
				sNFname.Empty();
				sNFMask.Empty();
				sCon.Empty();
				//BSTR bstrNFname	= pNFT->NoteFieldName;
				sNFname = (LPCSTR) pNFT->NoteFieldName;
				//BSTR bstrNFDefinition = pNFT->FieldDefinition;
				sNFMask	= (LPCSTR) pNFT->FieldDefinition;
				sCon	= sNFname + _T("[") + sNFMask + _T("]");
				m_Nfts.AddString(sCon);
				m_Nfnames.Add(sNFname);
				pNFT->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
}

void CEditCH::OnSelchangeAcctlist() 
{
	m_ChList.ResetContent();
	m_SubAcctList.ResetContent();
	LoadSubAccounts();

	m_Nfts.ResetContent();
	m_Nfnames.RemoveAll();
	m_Nfvalues.RemoveAll();
	//GetNFtemplateDetails();
	
	m_cnt_FName.SetWindowText(L"");
	m_Cnt_LName.SetWindowText(L"");
	m_Cnt_DOB.SetWindowText(L"");
	m_cnt_age.SetWindowText(L"");
	m_Cnt_St.SetWindowText(L"");
	m_cnt_State.SetWindowText(L"");
	m_cnt_country.SetWindowText(L"");
	m_Cnt_PHno.SetWindowText(L"");
	m_Btn_PhotoSave.EnableWindow(FALSE);
	m_Btn_SigSave.EnableWindow(FALSE);
	
}

void CEditCH::OnSelchangeSubAcctlist() 
{
	m_ChList.ResetContent();
	LoadCardHolders();

	m_Nfts.ResetContent();
	m_Nfnames.RemoveAll();
	m_Nfvalues.RemoveAll();
	GetNFtemplateDetails();
	
	m_cnt_FName.SetWindowText(L"");
	m_Cnt_LName.SetWindowText(L"");
	m_Cnt_DOB.SetWindowText(L"");
	m_cnt_age.SetWindowText(L"");
	m_Cnt_St.SetWindowText(L"");
	m_cnt_State.SetWindowText(L"");
	m_cnt_country.SetWindowText(L"");
	m_Cnt_PHno.SetWindowText(L"");
	m_Btn_PhotoSave.EnableWindow(FALSE);
	m_Btn_SigSave.EnableWindow(FALSE);
	
}

void CEditCH ::LoadCardHolders()
{
	//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		//select sub account name 
		int indexSub = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(indexSub,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		_variant_t vCHs;
		vCHs.Clear();
		pApplication->GetCardHoldersByAccountName(bstrAcctName,bstrSubAcctName, &vCHs); // get card holder details of particular account  in WP-CS database server
		
		if(vCHs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ICardHolder *pCH = NULL;
		
		COleSafeArray sa(vCHs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ICardHolder,(void**)&pCH);
			if (pCH != NULL)
			{
				CString sCHid;
				sCHid.Format(L"%ld",pCH->CardHolderID);
				m_ChList.AddString(sCHid);
				pCH->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_ChList.SetCurSel(0);
}

void CEditCH::GetCHDetails()
{
	
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		//select sub account name 
		int indexSub = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(indexSub,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		//select CHID
		int index_CH = m_ChList.GetCurSel();
		CString sCHid;
		m_ChList.GetLBText(index_CH,sCHid);
		long lCardHolderID = _wtoi(sCHid);

		// Getparticular card holder details
		_variant_t vCH;
		vCH.Clear();
		pApplication->GetCardHolderByCardHolderID(lCardHolderID,&vCH);
		ICardHolderPtr pcardholder(vCH.pdispVal);

		if(vCH.vt ==  VT_EMPTY)
		{
			return;
		}
		UpdateData(TRUE);
		m_Nfvalues.RemoveAll();
		if( vCH.vt & VT_DISPATCH)
		{		
			m_FirstName =CString(((LPWSTR)pcardholder->FirstName));
			m_LastName =CString(((LPWSTR)pcardholder->LastName));
			m_DOB=CString(((LPWSTR)pcardholder->NoteField["D.O.B"]));
			m_Age =CString(((LPWSTR)pcardholder->NoteField["#Age!"]));
			m_Street=CString(((LPWSTR)pcardholder->NoteField["Street's Name"]));
			m_Country =CString(((LPWSTR)pcardholder->NoteField["Country"]));
			m_Phno = CString(((LPWSTR)pcardholder->NoteField["Ph.No"]));
			m_State =CString(((LPWSTR)pcardholder->NoteField["Salary $$"]));
			//get notefields of cardholder
			for(int nfCount=0;nfCount<m_Nfnames.GetSize();nfCount++)
			{
				m_Nfvalues.Add(CString(((LPWSTR)pcardholder->NoteField[m_Nfnames.GetAt(nfCount).AllocSysString()])));
			}
		}
		//get the photo
		vgetphoto = pcardholder->Photo[1];
		//get the signature
		vgetSignature = pcardholder->Signature[1];
		UpdateData(FALSE);
		if(NULL != vCH.pdispVal)        
		{
			//vCH.pdispVal->Release();
			vCH.Clear();
		}
}



void CEditCH::OnSelchangeChlist() 
{
	GetCHDetails();
	m_cnt_FName.SetFocus();
	m_cnt_FName.SetSel(0,-1);
	m_Btn_PhotoSave.EnableWindow(TRUE);
	m_Btn_SigSave.EnableWindow(TRUE);
	
}

void CEditCH::OnEdit() 
{
		BSTR bstrAcctName;
		BSTR bstrSubAcctName;
		BSTR bstrFirstName;
		BSTR bstrLastName;
		BSTR bstrAge,bstrDob,bstrstreet,bstrCountry,bstrstate,bstrPhno;


		UpdateData(TRUE);
		//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}
		

		//select Sub account name 
		int index_SubAccount = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		if (index_SubAccount <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}

		//select CHID
		long lCardHolderID;
		int index_CH = m_ChList.GetCurSel();
		if (index_CH < 0)
			lCardHolderID = 0;
		else
		{
			CString sCHid;
			m_ChList.GetLBText(index_CH,sCHid);
			lCardHolderID = _wtoi(sCHid);
		}
		
		//get the CHfirstname and Last name
		bstrFirstName	= m_FirstName.AllocSysString();
		bstrLastName	= m_LastName.AllocSysString();
		//get Notefiedls Values;
		bstrDob			= m_DOB.AllocSysString();
		bstrAge			= m_Age.AllocSysString();
		bstrstreet		= m_Street.AllocSysString();
		bstrCountry		= m_Country.AllocSysString();
		bstrstate		= m_State.AllocSysString();
		bstrPhno		= m_Phno.AllocSysString();
		//set CH properties
		pCardHolder->AccountName= bstrAcctName;
		pCardHolder->FirstName= bstrFirstName;
		pCardHolder->LastName= bstrLastName;
		pCardHolder->SubAccountName= bstrSubAcctName;

		for(int nfCount=0;nfCount<m_Nfnames.GetSize();nfCount++)
		{
			pCardHolder->NoteField[m_Nfnames.GetAt(nfCount).AllocSysString()] = m_Nfvalues.GetAt(nfCount).AllocSysString();
		}
		//put notefields with NFT 	
		pCardHolder->NoteField["D.O.B"]=bstrDob;
		pCardHolder->NoteField["#AGE!"]=bstrAge;
		pCardHolder->NoteField["Street's Name"]=bstrstreet;
		pCardHolder->NoteField["Country"] =bstrCountry;
		pCardHolder->NoteField["Salary $$"]=bstrstate;
		pCardHolder->NoteField["Ph.No"]=bstrPhno;
		//WPACT-1002 Can use above code or use code given below if notefield indexing is known
		
	//update edited notefields with NFT 
		/*for(int notefieldcount=0;notefieldcount<6 && notefieldcount<m_Nfnames.GetSize();notefieldcount++)
		{
			switch(notefieldcount)
			{
				case 0:
					pCardHolder->NoteField[m_Nfnames.GetAt(notefieldcount).AllocSysString()]= bstrDob;
					break;
				case 1:
					pCardHolder->NoteField[m_Nfnames.GetAt(notefieldcount).AllocSysString()]= bstrAge;
					break;
				case 2:
					pCardHolder->NoteField[m_Nfnames.GetAt(notefieldcount).AllocSysString()]= bstrstreet;
					break;
				case 3:
					pCardHolder->NoteField[m_Nfnames.GetAt(notefieldcount).AllocSysString()] = bstrCountry;
					break;
				case 4:
					pCardHolder->NoteField[m_Nfnames.GetAt(notefieldcount).AllocSysString()]= bstrstate;
					break;
				case 5:
					pCardHolder->NoteField[m_Nfnames.GetAt(notefieldcount).AllocSysString()]= bstrPhno;
					break;
			}
		}	*/

	//add Card holder
		long lStatus;
		pApplication->EditCardHolder(lCardHolderID,pCardHolder,&lStatus);
		
		if ( lStatus == 301)
		{
			AfxMessageBox(L"Invalid Cardhodler Firsrname / Lastname");
			return;
		}
		if ( lStatus == 302)
		{
			AfxMessageBox(L"Invalid Cardhodler Firsrname / Lastname String Length");
			return;
		}
		//add photo to cardholder
		if (varPhoto.vt !=VT_NULL)
		{
			pCardHolder->Photo[1]=varPhoto;
		}
		else
		{
			varPhoto.vt =VT_NULL;
			pCardHolder->Photo[1]=varPhoto;
		}
	//add signature to CH
		if (varSignature.vt !=VT_NULL)
		{
			pCardHolder->Signature[1]=varSignature;
		}
		if ( lStatus == 1)
		{
			AfxMessageBox(L"CardHolder Edit Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"CardHolder Edit Succeded");
			CDialog::OnOK();
		}
		
}

void CEditCH::OnPhoto() 
{
	CFileDialog Dlg(TRUE,NULL,NULL,OFN_HIDEREADONLY,_T("Pictures (*.jpg)|*.jpg||"),this);
	
	if (Dlg.DoModal()!=IDOK){
		return;
	}
	COleSafeArray safeArray;
	// Open the file
	CString sPathName = Dlg.GetPathName();
	CFile File;
	if(File.Open(sPathName,CFile::shareDenyWrite|CFile::modeRead,NULL))
	{
		// Resize the database structure to hold the image
		long Length=static_cast<long>(File.GetLength());
		 safeArray.CreateOneDim( VT_UI1, Length );

		// This kind of blows-- I have to write the data out one
		// byte at a time.  To make things a little faster,
		// read the file into memory;

		BYTE *theContents = new BYTE[Length];
		File.Read( theContents, Length );
		for (long i = 0; i < Length; ++i )
		{
			safeArray.PutElement( &i, &(theContents[i]) );
		}

		delete[] theContents;
		varPhoto = safeArray.Detach();
		// Close the file
		File.Close();
	}
	
}

void CEditCH::OnSig() 
{
	
	CFileDialog Dlg(TRUE,NULL,NULL,OFN_HIDEREADONLY,_T("Signature (*.sig)|*.sig|Enhanced Metafile (*.emf)|*.emf||"),this);
	
	if (Dlg.DoModal()!=IDOK){
		return;
	}
	COleSafeArray safeArray;
	// Open the file
	CString sPathName = Dlg.GetPathName();
	CFile File;
	if(File.Open(sPathName,CFile::shareDenyWrite|CFile::modeRead,NULL))
	{
		// Resize the database structure to hold the image
		long Length= static_cast<long>(File.GetLength());
		 safeArray.CreateOneDim( VT_UI1, Length );

		// This kind of blows-- I have to write the data out one
		// byte at a time.  To make things a little faster,
		// read the file into memory;

		BYTE *theContents = new BYTE[Length];
		File.Read( theContents, Length );
		for (long i = 0; i < Length; ++i )
		{
			safeArray.PutElement( &i, &(theContents[i]) );
		}

		delete[] theContents;
		varSignature = safeArray.Detach();
		// Close the file
		File.Close();
	}	
	
}

void CEditCH::OnSave() 
{
	if(vgetphoto.vt == VT_NULL || vgetphoto.vt == VT_EMPTY)
	{
		AfxMessageBox(L"No Photo Available");
		return;
	}
	else
	{
		CFileDialog Dlg(FALSE,NULL,NULL,OFN_HIDEREADONLY,_T("Pictures (*.jpg)|*.jpg||"),this);
		if (Dlg.DoModal()!=IDOK){
			return;
		}

		CString sPathName = Dlg.GetPathName();
	
		long lStartBound = 0;
		long lEndBound = 0;
		SAFEARRAY* pSafeArray  = vgetphoto.parray; // put byte array value in safe array
		SafeArrayGetLBound(pSafeArray, 1, &lStartBound); //get the lower bound value
		SafeArrayGetUBound(pSafeArray, 1, &lEndBound);//get the upper bound value

		DWORD dwSize = (lEndBound-lStartBound+1)*sizeof(BYTE);//size of image
			
		BYTE* arrayAccess = NULL;
		SafeArrayAccessData(pSafeArray, (void**)&arrayAccess);//put image value from safe array to byte array
		
		SafeArrayDestroy(pSafeArray); 
		SafeArrayUnaccessData(pSafeArray);

		CFile File;
		File.Open(sPathName, CFile::modeCreate|CFile::modeWrite,NULL);
		File.Write((char*)arrayAccess ,dwSize);
		File.Close();
	}
}

void CEditCH::OnSaveSig() 
{
	
	if(vgetSignature.vt == VT_NULL || vgetSignature.vt == VT_EMPTY)
	{
		AfxMessageBox(L"No signature Available");
		return;
	}
	else
	{
		CFileDialog Dlg(FALSE,NULL,NULL,OFN_HIDEREADONLY,_T("Signature (*.sig)|*.sig|Enhanced Metafile (*.emf)|*.emf||"),this);
		if (Dlg.DoModal()!=IDOK){
			return;
		}

		CString sPathName = Dlg.GetPathName();
	
		long lStartBound = 0;
		long lEndBound = 0;
		SAFEARRAY* pSafeArray  = vgetSignature.parray; // put byte array value in safe array
		SafeArrayGetLBound(pSafeArray, 1, &lStartBound); //get the lower bound value
		SafeArrayGetUBound(pSafeArray, 1, &lEndBound);//get the upper bound value

		DWORD dwSize = (lEndBound-lStartBound+1)*sizeof(BYTE);//size of image
			
		BYTE* arrayAccess = NULL;
		SafeArrayAccessData(pSafeArray, (void**)&arrayAccess);//put image value from safe array to byte array
		
		SafeArrayDestroy(pSafeArray); 
		SafeArrayUnaccessData(pSafeArray);

		CFile File;
		File.Open(sPathName, CFile::modeCreate|CFile::modeWrite,NULL);
		File.Write((char*)arrayAccess ,dwSize);
		File.Close();
	}
}

void CEditCH::OnDelphoto() 
{
		
		long lStatus;
		//select CHID
		long lCardHolderID;
		int index_CH = m_ChList.GetCurSel();
		if (index_CH < 0)
			lCardHolderID = 0;
		else
		{
			CString sCHid;
			m_ChList.GetLBText(index_CH,sCHid);
			lCardHolderID = _wtoi(sCHid);
		}
		//delete a photo for specified card holder
		pApplication->DeletePhoto(lCardHolderID,1,&lStatus);

		if ( lStatus == 301)
		{
			AfxMessageBox(L"Invalid Cardhodler");
			return;
		}
		if(lStatus == 303)
		{
			AfxMessageBox(L"Invalid Index");
			return;
		}

		if ( lStatus == 1)
		{
			AfxMessageBox(L"Photo deletion Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Photo deletion Succeded");
			CDialog::OnOK();
		}
}

void CEditCH::OnDelsig() 
{
		long lStatus;
		//select CHID
		long lCardHolderID;
		int index_CH = m_ChList.GetCurSel();
		if (index_CH < 0)
			lCardHolderID = 0;
		else
		{
			CString sCHid;
			m_ChList.GetLBText(index_CH,sCHid);
			lCardHolderID = _wtoi(sCHid);
		}
		//delete a photo for specified card holder
		pApplication->DeleteSignature(lCardHolderID,1,&lStatus);

		if ( lStatus == 301)
		{
			AfxMessageBox(L"Invalid Cardhodler");
			return;
		}
		if(lStatus == 303)
		{
			AfxMessageBox(L"Invalid Index");
			return;
		}

		if ( lStatus == 1)
		{
			AfxMessageBox(L"Signature deletion Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Signature deletion Succeded");
			CDialog::OnOK();
		}
	
}
